/*
   This program reads one byte at a time from
   System.in using a buffer whose size is
   determined by the constant BUFFER_SIZE.

   The bytes are read at half second intervals.
   This lets you notice how this program's reads
   effect the buffering in the parent process.

   If you change the value of BUFFER_SIZE from 10
   to 20, you should see the output counter in the
   parent jump by the amount 20 instead of by 10's.
   Each time this child empties its input buffer, it
   will refill the buffer (with 10 or 20 bytes) using
   a single call to read() from the parent's output
   stream.
*/
import java.util.Scanner;
import java.io.*;

public class Ex2_WatchBuffering_Child
{
   static boolean raw = true;

   public static void main(String[] args) throws IOException, InterruptedException
   {
      final int BUFFER_SIZE = 10;  // Try changing this to 20.
      System.setIn( new BufferedInputStream( new FileInputStream(FileDescriptor.in), BUFFER_SIZE ) );

      Scanner scanner = new Scanner( System.in );

      Thread.sleep(5000);  // Let the parent run for 5 sec before reading any bytes.
                           // This lets the parent fill up the pipe buffer.
      int b = System.in.read();
      while ( -1 != b )
      {
         b = System.in.read();
         Thread.sleep(500);  // half second
      }
   }
}